
<?php
// Session + auth helpers
if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/../../bridge/wp_bridge.php';
require_once __DIR__ . '/functions.php';

function login_with_wp($login_or_email, $password){
    $u = wp_find_user($login_or_email);
    if (!$u) return [false, 'User not found'];
    if (!wp_verify_password($password, $u['user_pass'])) return [false, 'Invalid password'];
    kmz_set_role_if_missing((int)$u['ID'], 'customer');
    $_SESSION['user_id'] = (int)$u['ID'];
    $_SESSION['user_name'] = $u['display_name'] ?: $u['user_login'];
    $_SESSION['role'] = kmz_get_role((int)$u['ID']) ?: 'customer';
    return [true, null];
}

function require_login(){
    if (!isset($_SESSION['user_id'])) {
        redirect('/login.php');
    }
}
function require_roles(array $roles){
    require_login();
    $r = $_SESSION['role'] ?? '';
    if (!in_array($r, $roles, true)) {
        http_response_code(403);
        echo "<h1>403</h1><p>Access denied for role: ".esc($r)."</p>";
        exit;
    }
}
function logout(){ session_destroy(); redirect('/login.php'); }
