
<?php
require_once __DIR__.'/includes/auth.php';
require_roles(['super_admin']);
require_once __DIR__.'/../config/db.php';

$stats = [
    'bookings_today' => $pdo->query("SELECT COUNT(*) c FROM bookings WHERE booking_date = CURDATE()")->fetch()['c'] ?? 0,
    'revenue_today'  => $pdo->query("SELECT IFNULL(SUM(amount),0) s FROM payments WHERE status='paid' AND DATE(created_at)=CURDATE()")->fetch()['s'] ?? 0,
    'pending_pay'    => $pdo->query("SELECT IFNULL(SUM(balance_amount),0) s FROM bookings WHERE status IN ('pending','reserved')")->fetch()['s'] ?? 0,
];
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Super Admin</title>
<link rel="stylesheet" href="/assets/css/style.css"/>
</head><body>
<main class="container">
  <h1>Super Admin</h1>
  <div class="grid">
    <div class="card"><h3>Bookings Today</h3><p><?php echo esc($stats['bookings_today']); ?></p></div>
    <div class="card"><h3>Revenue Today</h3><p><?php echo money($stats['revenue_today']); ?></p></div>
    <div class="card"><h3>Outstanding</h3><p><?php echo money($stats['pending_pay']); ?></p></div>
  </div>
  <h2>Links</h2>
  <ul>
    <li><a href="/office-admin.php">Office Admin</a></li>
    <li><a href="/bookings.php">Bookings</a></li>
    <li><a href="/logout.php">Logout</a></li>
  </ul>
  <h2>Recent Woo Orders (read-only)</h2>
  <pre><?php
    require_once __DIR__.'/../bridge/woo_queries.php';
    echo esc(json_encode(woo_recent_orders(10), JSON_PRETTY_PRINT));
  ?></pre>
</main>
</body></html>
