
<?php
require_once __DIR__.'/includes/auth.php';
require_login();
require_once __DIR__.'/../config/db.php';

$uid = (int)($_SESSION['user_id'] ?? 0);
$stmt = $pdo->prepare("SELECT * FROM bookings WHERE customer_user_id = ? ORDER BY created_at DESC LIMIT 50");
$stmt->execute([$uid]);
$rows = $stmt->fetchAll();
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>My Bookings</title>
<link rel="stylesheet" href="/assets/css/style.css"/>
</head><body>
<main class="container">
  <h1>My Bookings</h1>
  <table class="table">
    <thead><tr><th>Code</th><th>Date</th><th>Time</th><th>Total</th><th>Status</th><th></th></tr></thead>
    <tbody>
      <?php foreach ($rows as $r): ?>
      <tr>
        <td><?php echo esc($r['booking_code']); ?></td>
        <td><?php echo esc($r['booking_date']); ?></td>
        <td><?php echo esc(substr($r['slot_time'],0,5)); ?></td>
        <td><?php echo money($r['total_amount']); ?></td>
        <td><?php echo esc($r['status']); ?></td>
        <td>
          <?php if (in_array($r['status'], ['pending','reserved'])): ?>
          <a class="btn" href="/pay/start.php?booking_id=<?php echo (int)$r['id']; ?>">Pay</a>
          <?php endif; ?>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
  <p><a href="/logout.php">Logout</a></p>
</main>
</body></html>
