
<?php
// Yoco webhook receiver (configure in Yoco dashboard)
require_once __DIR__ . '/../../config/db.php';

$raw = file_get_contents('php://input');
$data = json_decode($raw, true) ?: [];

// Very light validation; consider validating signatures if available.
$event = $data['event'] ?? '';
$obj   = $data['data']  ?? [];
$checkout_id = $obj.get('id','');
$status = strtolower($obj.get('status',''));
$amount = isset($obj['amount']) ? ((float)$obj['amount']/100.0) : 0.0;
$booking_id = isset($obj['metadata']['booking_id']) ? (int)$obj['metadata']['booking_id'] : null;

// Store raw
$pdo->prepare("INSERT INTO audit_logs (user_id, action, details, created_at) VALUES (NULL, 'yoco_webhook', ?, NOW())")
    ->execute([$raw]);

if ($booking_id && in_array($status, ['paid','successful','succeeded','complete'])) {
    // Mark payment as paid
    $pdo->prepare("UPDATE payments SET status='paid' WHERE booking_id=? AND gateway='yoco' ORDER BY id DESC LIMIT 1")
        ->execute([$booking_id]);
    // Reduce balance
    $pdo->prepare("UPDATE bookings SET status='paid', balance_amount=GREATEST(0, balance_amount - ?), updated_at=NOW() WHERE id=?")
        ->execute([$amount, $booking_id]);
}

http_response_code(200);
echo 'ok';
