
<?php
require_once __DIR__.'/includes/auth.php';
require_login();
require_once __DIR__.'/../config/db.php';

// Handle actions
if (is_post()) {
    $action = $_POST['action'] ?? '';
    if ($action === 'create') {
        $uid = (int)$_SESSION['user_id'];
        $date = $_POST['booking_date'] ?? '';
        $time = $_POST['slot_time'] ?? '';
        $adults = max(1, (int)($_POST['pax_adults'] ?? 1));
        $kids = max(0, (int)($_POST['pax_kids'] ?? 0));
        $total = (float)($_POST['total_amount'] ?? 0);
        $code = strtoupper(substr(md5(uniqid('', true)),0,8));
        $stmt = $pdo->prepare("INSERT INTO bookings (booking_code, customer_user_id, booking_date, slot_time, pax_adults, pax_kids, status, total_amount, balance_amount, created_at, updated_at) VALUES (?,?,?,?,?,?, 'reserved', ?, ?, NOW(), NOW())");
        $stmt->execute([$code, $uid, $date, $time, $adults, $kids, $total, $total]);
        redirect('/customer-dashboard.php');
    } elseif ($action === 'check_in') {
        require_roles(['office_admin','super_admin']);
        $id = (int)($_POST['id'] ?? 0);
        $stmt = $pdo->prepare("UPDATE bookings SET status='checked_in', check_in_at=NOW(), updated_at=NOW() WHERE id=?");
        $stmt->execute([$id]);
        redirect('/office-admin.php');
    }
}

?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Bookings</title>
<link rel="stylesheet" href="/assets/css/style.css"/>
</head><body>
<main class="container">
  <h1>Create a Booking (MVP)</h1>
  <form method="post">
    <input type="hidden" name="action" value="create">
    <div class="grid two">
      <label>Date <input type="date" name="booking_date" required></label>
      <label>Time <input type="time" name="slot_time" required></label>
      <label>Adults <input type="number" name="pax_adults" value="1" min="1"></label>
      <label>Kids <input type="number" name="pax_kids" value="0" min="0"></label>
      <label>Total (ZAR) <input type="number" step="0.01" name="total_amount" value="350.00"></label>
    </div>
    <button class="btn">Save</button>
  </form>
  <p><a href="/customer-dashboard.php">My Bookings</a></p>
</main>
</body></html>
