
<?php
// bridge/wp_bridge.php
require_once __DIR__ . '/../config/db.php';

// Minimal PHPass implementation (WordPress compatible)
// Source adapted from the portable PHP password hashing framework.
class PasswordHash {
    var $itoa64;
    var $iteration_count_log2;
    var $portable_hashes;
    var $random_state;
    function __construct($iteration_count_log2, $portable_hashes) {
        $this->itoa64 = './0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
        $this->iteration_count_log2 = $iteration_count_log2;
        $this->portable_hashes = $portable_hashes;
        $this->random_state = microtime() . uniqid();
    }
    function decode64($input, $count) {
        $output = 0;
        $i = 0;
        for ($i = 0; $i < $count; $i++) {
            $value = strpos($this->itoa64, $input[$i]);
            $output |= $value << ($i * 6);
        }
        return $output;
    }
    function gensalt_private($input) {
        $output = '$P$';
        $output .= $this->itoa64[min($this->iteration_count_log2 + 5, 30)];
        $output .= $this->encode64($input, 6);
        return $output;
    }
    function encode64($input, $count) {
        $output = '';
        $i = 0;
        do {
            $value = ord($input[$i++]);
            $output .= $this->itoa64[$value & 0x3f];
            if ($i < $count)
            {
                $value |= ord($input[$i]) << 8;
            }
            $output .= $this->itoa64[($value >> 6) & 0x3f];
            if ($i++ >= $count) break;
            if ($i < $count)
            {
                $value |= ord($input[$i]) << 16;
            }
            $output .= $this->itoa64[($value >> 12) & 0x3f];
            if ($i++ >= $count) break;
            $output .= $this->itoa64[($value >> 18) & 0x3f];
        } while ($i < $count);
        return $output;
    }
    function crypt_private($password, $setting) {
        $output = '*0';
        if (substr($setting, 0, 2) == '*0') $output = '*1';
        $id = substr($setting, 0, 3);
        if ($id != '$P$' && $id != '$H$') return $output;
        $count_log2 = strpos($this->itoa64, $setting[3]);
        if ($count_log2 < 7 || $count_log2 > 30) return $output;
        $count = 1 << $count_log2;
        $salt = substr($setting, 4, 8);
        if (strlen($salt) != 8) return $output;
        $hash = md5($salt . $password, TRUE);
        do {
            $hash = md5($hash . $password, TRUE);
        } while (--$count);
        $output = substr($setting, 0, 12);
        $output .= $this->encode64($hash, 16);
        return $output;
    }
    function CheckPassword($password, $stored_hash) {
        if (strlen($stored_hash) == 34)
            return $this->crypt_private($password, $stored_hash) === $stored_hash;
        return password_verify($password, $stored_hash);
    }
}

function wp_find_user($login_or_email) {
    global $pdo, $WP_PREFIX;
    $sql = "SELECT ID, user_login, user_pass, user_email, display_name FROM {$WP_PREFIX}users WHERE user_login = ? OR user_email = ? LIMIT 1";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$login_or_email, $login_or_email]);
    return $stmt->fetch() ?: null;
}

function wp_verify_password($password, $hash) {
    $hasher = new PasswordHash(8, true);
    return $hasher->CheckPassword($password, $hash);
}

function kmz_get_role($user_id) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT role FROM kmz_roles WHERE user_id = ? LIMIT 1");
    $stmt->execute([$user_id]);
    $r = $stmt->fetch();
    return $r ? $r['role'] : null;
}

function kmz_set_role_if_missing($user_id, $role='customer') {
    global $pdo;
    $stmt = $pdo->prepare("INSERT IGNORE INTO kmz_roles (user_id, role, created_at) VALUES (?, ?, NOW())");
    $stmt->execute([$user_id, $role]);
}
