
<?php
// bridge/woo_queries.php
// Examples to read WooCommerce orders/items from WordPress DB.
require_once __DIR__ . '/../config/db.php';

function woo_recent_orders($limit=20) {
    global $pdo, $WP_PREFIX;
    $sql = "
        SELECT p.ID as order_id, p.post_date as ordered_at, p.post_status,
               pm_total.meta_value as order_total, pm_email.meta_value as billing_email
        FROM {$WP_PREFIX}posts p
        LEFT JOIN {$WP_PREFIX}postmeta pm_total ON pm_total.post_id = p.ID AND pm_total.meta_key = '_order_total'
        LEFT JOIN {$WP_PREFIX}postmeta pm_email ON pm_email.post_id = p.ID AND pm_email.meta_key = '_billing_email'
        WHERE p.post_type = 'shop_order'
        ORDER BY p.post_date DESC
        LIMIT :limit
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->bindValue(':limit', (int)$limit, PDO::PARAM_INT);
    $stmt->execute();
    return $stmt->fetchAll();
}

function woo_order_line_items($order_id) {
    global $pdo, $WP_PREFIX;
    $sql = "
        SELECT oi.order_item_id, oi.order_item_name, oim1.meta_value AS product_id, oim2.meta_value AS qty
        FROM {$WP_PREFIX}woocommerce_order_items oi
        LEFT JOIN {$WP_PREFIX}woocommerce_order_itemmeta oim1 ON oim1.order_item_id = oi.order_item_id AND oim1.meta_key = '_product_id'
        LEFT JOIN {$WP_PREFIX}woocommerce_order_itemmeta oim2 ON oim2.order_item_id = oi.order_item_id AND oim2.meta_key = '_qty'
        WHERE oi.order_id = ? AND oi.order_item_type = 'line_item'
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$order_id]);
    return $stmt->fetchAll();
}
